
'use strict';
jQuery(function($) {
    $.fn.vcAnimatedGradient = function(Options, Callback) {
        var CreateElement = $(this);
        var ElementId = CreateElement.attr("id");
        var parentRow = getParentRow(CreateElement);
        parentRow.css("position", "relative");
        var Element = parentRow.prepend('<div id="' + ElementId + '" style="background-color:' + (CreateElement.attr("data-bgcolor") ? CreateElement.attr("data-bgcolor") : '#000000') + '" class="vc-animatedgradient-background-bg"><canvas id="' + ElementId +  '-output"></canvas></div>');

		$("#" + ElementId + "-output").animatedCanvasGradient({ 
			'duration': CreateElement.attr("data-duration") ? CreateElement.attr("data-duration") : '3000',
			'stopAColor' : CreateElement.attr("data-stopacolor") ? JSON.parse(CreateElement.attr("data-stopacolor")) : [ { 'r':'205', 'g':'24', 'b':'75' },{ 'r':'33', 'g':'98', 'b':'155' }],			
			'stopBColor' : CreateElement.attr("data-stopbcolor") ? JSON.parse(CreateElement.attr("data-stopbcolor")) : [ { 'r':'33', 'g':'98', 'b':'155' },{ 'r':'205', 'g':'24', 'b':'75' }],
			'direction' :  CreateElement.attr("data-direction") ? CreateElement.attr("data-direction") : 'topbottom'
		});
        CreateElement.remove();

        function getParentRow(Element) {
            return Element.parents(".boomapps_vcrow, .vc_row, .wpb_row").eq(0);
        }
    }


    $(".vc-animatedgradient-background").each(function() {
        $(this).vcAnimatedGradient();
    });



});